#include "WeightedPoint.hpp"

WeightedPoint::WeightedPoint() :
	Point(),
	weight(1)
{
}

WeightedPoint::WeightedPoint(Point const & point) :
	Point(point),
	weight(1)
{
}

WeightedPoint::WeightedPoint(std::vector<double> const & coordinates) :
	Point(coordinates),
	weight(1)
{
}

WeightedPoint::WeightedPoint(std::vector<double> const & coordinates, double weight) :
	Point(coordinates),
	weight(weight)
{
}

void WeightedPoint::setWeight(double weight)
{
	this->weight = weight;
}

double WeightedPoint::getWeight() const
{
	return weight;
}

std::ostream& operator<<(std::ostream & stream, WeightedPoint const & point)
{
	stream << "(";
	int i = 1;
	for(auto it = point.cbegin(); it != point.cend(); ++it)
	{
		stream << *it;
		if(i < point.getDimension())
			stream << ",";
		++i;
	}
	stream << "),w=" << point.getWeight();
	return stream;
}
