#ifndef PROBABILISTICPOINT_H
#define PROBABILISTICPOINT_H

#include <vector>
#include <utility>

#include "WeightedPoint.hpp"

/**
 * @brief Probabilistic point
 */
class ProbabilisticPoint
{
public:
	// constructors
	ProbabilisticPoint(std::vector<WeightedPoint> distribution);
	ProbabilisticPoint(std::vector<WeightedPoint> distribution, double weight);

	// operators
	WeightedPoint & operator[] (int index);
	WeightedPoint const & operator[] (int index) const;

	// iterators
	std::vector<WeightedPoint>::const_iterator cbegin() const;
	std::vector<WeightedPoint>::const_iterator cend() const;
	typedef std::vector<WeightedPoint>::const_iterator citerator;
	
	// accessors / mutators
	void setWeight(double weight);
	unsigned int getSizeOfDistribution() const;
	double getWeight() const;
	double getRealizationProbability() const;
	
private:
	std::vector<WeightedPoint> distribution;
	double weight;
	double realizationProbability;
};

#endif
